/*****************************************************************************/
/*                         Freescale Semiconductor                           */
/*****************************************************************************/
/* File Type: C Source File                                                  */
/* File Name: Table.c                                                        */
/* Description: Code to draw tables on a NewHeaven TFT display               */
/* Author: Jos Santiago Lpez Ramrez                                       */
/* Date: 29/10/10                                                            */
/* Version: 2.0 (For rendered characters)                                    */
/*****************************************************************************/

/*****************************************************************************/
/*                                  Headers                                  */
/*****************************************************************************/

  #include "Table.h"

/*****************************************************************************/
/*                                  Globals                                  */
/*****************************************************************************/
  
  extern UINT8 gu8Table_Index = 2;
  extern UINT8 Page = 1;
  UINT32 Pager[128];
  
  UINT8 Tdata[8][Max_string_size+7];
  UINT8 SDT_Buffer[SD_Buffer_Size] = {0};     
  UINT32 Calctr=0;
  UINT8 gu8TableFirstStart=True;
  
/*****************************************************************************/
/*                                  Functions                                */
/*****************************************************************************/

void Fill_Row (UINT8 *string, UINT8 RB, UINT8 GB, UINT8 BB, UINT8 RF, UINT8 GF, UINT8 BF, UINT8 line)
{
 UINT32 xspos;
 UINT8 array[10],indx,ColorLB,ColorHB;
 
 xspos = 128-((line-1)*13);
 New_fntcolor(RF,GF,BF,RB,GB,BB);
 
 /*************** Paints the row ***************/
 colorArea(xspos-13, xspos-1, 1, 158,Convert_888_to_565(RB,GB,BB,1),Convert_888_to_565(RB,GB,BB,0));
 
 /**************** Draws Table *****************/
 ColorLB=Convert_888_to_565(tblcolor,0);
 ColorHB=Convert_888_to_565(tblcolor,1);
 colorArea(xspos, xspos, 0, 159,ColorHB,ColorLB);
 colorArea(xspos-13, xspos-13, 0, 159,ColorHB,ColorLB);
 colorArea(xspos-13, xspos, 0, 0,ColorHB,ColorLB);
 colorArea(xspos-13, xspos, dietmcol, dietmcol,ColorHB,ColorLB);
 colorArea(xspos-13, xspos, 159, 159,ColorHB,ColorLB);
 
 /****************  Fills Row  *****************/
 indx = 0;
 while(*string != rowend)
 {
  if (*string == '~')
   {
   indx++;
   break;
   }
  if(*string != ',')
  {
   array[indx]=(UINT8)*string;
   indx++;
  } else
  {
   array[indx]=0;
   Write_Str_LCD(array,xspos-12,2);
   indx=0;
  }
  string++;
 }
 array[indx-1]=0;
 Write_Str_LCD(array, xspos-12, dietmcol+2); 
}

/*************************************************************************************/

//Hold ON!!!!
 
  //////////////////////////////////////////////////////////////////


UINT8 Table_Pager(UINT8 *SD_Buffer)
{
 UINT8 pindx=1,tblindx=0;
 UINT32 ctr=0;
 Pager[1]=0;
 
 while(*SD_Buffer)
 {
  if (*SD_Buffer == rowend)
  {
   tblindx++;
   if(tblindx > 7)
   {
    pindx++;
    Pager[pindx]=ctr+1;
    tblindx = 0;
   }
  }
  SD_Buffer++;
  ctr++;
 }
return pindx;
}

/****************************************************************************************/

void Fill_TableData (UINT8 *SD_Buffer)
{
 static UINT8 tdindx, ctr;
 static UINT8 Lastindx, Lastpg;
 
 tdindx=0;
 ctr=0;
 
 if(gu8TableFirstStart)
 {
  Lastpg=Page+1;
  gu8TableFirstStart=False;
 }
 
 if(Lastpg == Page)
  {
   
   if(Tdata[gu8Table_Index-2][0]==0)
   gu8Table_Index =2;
   
   Fill_Row(&Tdata[gu8Table_Index-2][0],Scolor,White,gu8Table_Index);
   
    if (Lastindx != gu8Table_Index)
    {    
      ctr=Lastindx%2;
    
      if(ctr==0)
      {
       Fill_Row(&Tdata[Lastindx-2][0], orwcolor, Black, Lastindx);
      } 
    
      else
      {
       Fill_Row(&Tdata[Lastindx-2][0], prwcolor, Black, Lastindx);
      }
    
      tdindx=8;                                   
    }
    
   } else
   
   {
     
     vfnPrint_SD_Image("TABLE.AMI",0,0);
     //Fill_Row((UINT8*)("FOOD TYPE,CAL~"), thcolor, White, 1);
   
     SD_Buffer += Pager[Page];
   
     while (*SD_Buffer != 0 && tdindx < 8)
     {
      if(*SD_Buffer != rowend)
      { 
       /*Cuts big strings*/
       if(*SD_Buffer==',' && ctr>Max_string_size)
       {
        ctr=Max_string_size+1;
       }
       /*Fills Row Data*/
       Tdata[tdindx][ctr] = (UINT8)*SD_Buffer;
       ctr++;
       
      }else
      { 
       Tdata[tdindx][ctr] = (UINT8)*SD_Buffer;
       if(gu8Table_Index == tdindx+2)
       {
        Fill_Row(&Tdata[tdindx][0], Scolor, White, tdindx+2);
       }else
       {
        ctr=tdindx%2;
        if(ctr==0)
        {
         Fill_Row(&Tdata[tdindx][0], orwcolor, Black, tdindx+2);
        } else
        {
         Fill_Row(&Tdata[tdindx][0], prwcolor, Black, tdindx+2);
        }
       }
       ctr=0;
       tdindx++;
      }
      SD_Buffer++;
     }
   
     if(*SD_Buffer == 0)
     {
      Tdata[tdindx][0]=0;
      }
            
   }
   
   Lastindx = gu8Table_Index;
   Lastpg = Page;
   
 }

/****************************************************************************************/

void Add_Engy(void)
{
 UINT32 Nbuffer[6];
 UINT8 Table_Index=1, pot=0,mult,muindx,*ptr;
 
 Fill_Row(&Tdata[gu8Table_Index-2][0],Black,White,gu8Table_Index);
 ptr = &Tdata[(gu8Table_Index-2)][0];
 while (*ptr != ',')
 {
  ptr++;
 }
 ptr++;
 while(*ptr > 47 && *ptr < 58)
 {
  Nbuffer[Table_Index]=*ptr;
  ptr++;
 Table_Index++;
 }
 Table_Index--;
 for(Table_Index;Table_Index!=0;Table_Index--)
 {
  muindx = pot;
  mult=1;
  while(muindx != 0)
  {
   mult*=10;
   muindx--;
  }
  Nbuffer[Table_Index]-=48;
  Calctr +=Nbuffer[Table_Index]*mult;
  pot++;
 }                                                              
}

/****************************************************************************************/

void Show_Cal(void)
{
 UINT8 CalSep[6], tms;
 
 if(Calctr>99999)
 Calctr=0;
 
 CalSep[0]= Calctr/10000;
 CalSep[1]= (Calctr/1000)-(CalSep[0]*10);
 CalSep[2]= (Calctr/100)-(CalSep[0]*100)-(CalSep[1]*10);
 CalSep[3]= (Calctr/10)-(CalSep[0]*1000)-(CalSep[1]*100)-(CalSep[2]*10);
 CalSep[4]= Calctr-(CalSep[0]*10000)-(CalSep[1]*1000)-(CalSep[2]*100)-(CalSep[3]*10);
 
 for(tms=0;tms<5;tms++)
 {
  CalSep[tms]+=48;
 }
 CalSep[5]=0;
 New_fntcolor(White,Tblbkg);

 colorArea(0, 9, 40, 90,Convert_888_to_565(Tblbkg,1),Convert_888_to_565(Tblbkg,0));
 //Write_Str_LCD((UINT8*)("Calories:"),0x00,0x01); 
 Write_Str_LCD(&CalSep[0],0,40); 
}

/****************************************************************************************/

void Table_Manager (void)
{
 volatile UINT8 Npages = Table_Pager(Buffer_SD);
 volatile UINT8 Apage, u8TableButtonPressed=True;
 volatile UINT32 u32PreviousCalctr;
 
 Apage=0;
 Page=1;
 
 while(gu8ButtonStatus!=BUTTON_EXIT)
 {
 
  TSS_Task();
  switch(gu8ButtonStatus)
  {
   case BUTTON_UP:
   gu8Table_Index--;
   u8TableButtonPressed=True;
   break;
   
   case BUTTON_DOWN:
   gu8Table_Index++;
   u8TableButtonPressed=True;
   break;
   
   case BUTTON_LEFT:
   Page--;
   u8TableButtonPressed=True;
   break;
   
   case BUTTON_RIGHT:
   Page++;
   u8TableButtonPressed=True;
   break;
   
   case BUTTON_SELECT:
   Add_Engy();
   u8TableButtonPressed=True;
   break;
   
   default:
   break;
  }
 
  if(gu8Table_Index == 1)
  {
   gu8Table_Index = 2;
   Page--;
  }
 
  if(gu8Table_Index == 10)
  {
   Page++;
   gu8Table_Index = 2;
  }
 
  if(Page == 0)
  {
   Page++;
  }
 
  if(Page > Npages)
  {
   Page--;
  }
 
  if(Apage != Page)
  {
  Fulldisplay(Convert_888_to_565(Tblbkg,1),Convert_888_to_565(Tblbkg,0)); 
  }
  if (u8TableButtonPressed)
  {
  Fill_TableData(Buffer_SD);
  Show_Cal();
  Apage=Page;
  gu8ButtonStatus=BUTTON_IDDLE;
  u8TableButtonPressed=False;
  }
  //_Wait;
 }
 gu8TableFirstStart=True;
 u32PreviousCalctr=u32CaloriesCountSDHandler(LOAD_CALORIES);
 if(u32PreviousCalctr!=Calctr)
 u32CaloriesCountSDHandler(SAVE_CALORIES);
 
}

/******************************************************************************************/
void GetdatafromSD (void)
{
 UINT16 u16SD_Buffer=0;
 volatile UINT16 u16SD_Phyblocksize=0;
 UINT16 u16SD_BufferIndex;
 volatile UINT8  SD_Status;
 UINT8 u8buffer[512];
 
 SD_Status= FAT_FileOpen((UINT8*)"TABLE.CSV",READ);
 
 if(SD_Status==FILE_FOUND)
 {
      do
    {  
      //Return of funtion FAT_FileRead indicates how many bytes were read
      //To read a complete file, this function should be invoked until it returns zero
      u16SD_Phyblocksize = FAT_FileRead(u8buffer); 
      for (u16SD_BufferIndex=0; u16SD_BufferIndex<u16SD_Phyblocksize; u16SD_BufferIndex++)
      {
        Buffer_SD[u16SD_Buffer]=u8buffer[u16SD_BufferIndex];
        u16SD_Buffer++; 
      }
    }
    while (u16SD_Phyblocksize);
 } 
 
 else
 {
  Fulldisplay(Convert_888_to_565(Darkblue,1),Convert_888_to_565(Darkblue,0));
  New_fntcolor(White,Darkblue);
  Write_Str_LCD((UINT8*)"File can not be found",(UINT8)(127-ltrheight),0);
  Write_Str_LCD((UINT8*)"File system may be corrupt",(UINT8)(127-2*ltrheight),0);
  for(;;){};
 }
}

/********************************************************************************************/

 UINT32 u32CaloriesCountSDHandler (UINT8 u8Task)
 {
  UINT8 u8SD_Status;
  UINT8 u8ReadBuffer[512];
  UINT8 u8CalctrSeparator[2];
  UINT32 u32CalctrValue;
  
  if (!SD_PRESENT) //Check for SD
  {
   u8SD_Status=FAT_FileOpen(CALORIES_FILE,MODIFY);

   if(u8SD_Status==FILE_NOT_FOUND)
   {
    FAT_FileOpen(CALORIES_FILE,CREATE);
    u32CalctrValue=0;
   }
   
   FAT_FileClose();
   
   if(u8SD_Status == FILE_FOUND)
   {
    switch (u8Task)
    {
      case LOAD_CALORIES:
      u8SD_Status=FAT_FileOpen(CALORIES_FILE,READ);
      if(u8SD_Status==FILE_FOUND)
      {
       FAT_FileRead(u8ReadBuffer);
       u32CalctrValue=u8ReadBuffer[0];
       u32CalctrValue=u32CalctrValue<<8;
       u32CalctrValue|=u8ReadBuffer[1];
      }
      break;
      
      case SAVE_CALORIES:
      u8SD_Status=FAT_FileOpen(CALORIES_FILE,OVERWRITE);
      if(u8SD_Status==FILE_FOUND)
      {
       u32CalctrValue=Calctr;
       u8CalctrSeparator[1]=(UINT8)u32CalctrValue;
       u32CalctrValue=u32CalctrValue>>8;
       u8CalctrSeparator[0]=(UINT8)u32CalctrValue;
       FAT_FileWrite(u8CalctrSeparator,2);
       u32CalctrValue=0;
       FAT_FileClose();
      }
      break;
      
      default:
      break;
    }
   }  
  }
  return u32CalctrValue;
 } 